﻿function Confirm-TSProgressUISetup(){
    if ($Script:TaskSequenceProgressUi -eq $null){
        try{$Script:TaskSequenceProgressUi = New-Object -ComObject Microsoft.SMS.TSProgressUI}
        catch{throw "Unable to connect to the Task Sequence Progress UI! Please verify you are in a running Task Sequence Environment. Please note: TSProgressUI cannot be loaded during a prestart command.`n`nErrorDetails:`n$_"}
        }
    }

function Confirm-TSEnvironmentSetup(){
    if ($Script:TaskSequenceEnvironment -eq $null){
        try{$Script:TaskSequenceEnvironment = New-Object -ComObject Microsoft.SMS.TSEnvironment}
        catch{throw "Unable to connect to the Task Sequence Environment! Please verify you are in a running Task Sequence Environment.`n`nErrorDetails:`n$_"}
        }
    }

function Show-TSActionProgress()
{

    param(
        [Parameter(Mandatory=$true)]
        [string] $Message,
        [Parameter(Mandatory=$true)]
        [long] $Step,
        [Parameter(Mandatory=$true)]
        [long] $MaxStep
    )

    Confirm-TSProgressUISetup
    Confirm-TSEnvironmentSetup

    $Script:TaskSequenceProgressUi.ShowActionProgress(`
        $Script:TaskSequenceEnvironment.Value("_SMSTSOrgName"),`
        $Script:TaskSequenceEnvironment.Value("_SMSTSPackageName"),`
        $Script:TaskSequenceEnvironment.Value("_SMSTSCustomProgressDialogMessage"),`
        $Script:TaskSequenceEnvironment.Value("_SMSTSCurrentActionName"),`
        [Convert]::ToUInt32($Script:TaskSequenceEnvironment.Value("_SMSTSNextInstructionPointer")),`
        [Convert]::ToUInt32($Script:TaskSequenceEnvironment.Value("_SMSTSInstructionTableSize")),`
        $Message,`
        $Step,`
        $MaxStep)
}

Function Get-CheckPointStatus {
$global:CheckPointRegistryPath = 'HKLM:\SOFTWARE\WOW6432Node\CheckPoint\Endpoint Security\Full Disk Encryption\Status\Current Boot'
$global:CheckPointRegistryItem = Get-Item -Path $CheckPointRegistryPath  
if (Test-Path $CheckPointRegistryPath)
    {
    $global:encryptionState = $CheckPointRegistryItem.GetValue('encryptionState')
    $global:encryptionStateTable =@(
    @{ Value = "0"; Friendly = "Not Encrypted"}
    @{ Value = "0,0"; Friendly = "Not Encrypted"}
    @{ Value = "1"; Friendly = "Encrypting"}
    @{ Value = "0,1"; Friendly = "Encrypting"}
    @{ Value = "2"; Friendly = "Decrypting"}
    @{ Value = "0,2"; Friendly = "Decrypting"}
    @{ Value = "3"; Friendly = "Encrypted"}
    @{ Value = "0,3"; Friendly = "Encrypted"}
    ) 
    $global:encryptionStateStatus = ($encryptionStateTable | Where-Object {$_.Value -eq $encryptionState}).Friendly
    $global:clientStatusDetails = $CheckPointRegistryItem.GetValue('clientStatusDetails')
    $global:clientStatus = $CheckPointRegistryItem.GetValue('clientStatus')
    $global:clientStatusTable =@(
    @{ Value = "0"; Friendly = "Initialize"}
    @{ Value = "5"; Friendly = "Awaiting configuration"}
    @{ Value = "10"; Friendly = "User acquisition"}
    @{ Value = "20"; Friendly = "Verifying setup"}
    @{ Value = "30"; Friendly = "Setup protection"}
    @{ Value = "40"; Friendly = "Awaiting reboot to show Preboot for 1st time"}
    @{ Value = "45"; Friendly = "Awaiting recovery data delivery"}
    @{ Value = "50"; Friendly = "Encrypting"}
    @{ Value = "60"; Friendly = "Decrypting"}
    @{ Value = "70"; Friendly = "Encrypted"}
    @{ Value = "80"; Friendly = "Unencrypted"}
    ) 
    $global:clientStatusValue = ($clientStatusTable | Where-Object {$_.Value -eq $clientStatus}).Friendly
    $global:clientStatusDetails = $CheckPointRegistryItem.GetValue('clientStatusDetails')
    }

}

Get-CheckPointStatus
Write-Output "------------------------------------------"
Write-Output " "
#write overall status:
Write-Output "Encrypted Status: $encryptionStateStatus"
Write-Output "Client Status: $clientStatusValue"
Write-Output " "
Write-Output "------------------------------------------"
Write-Output " "
#Start Looping for waiting:
if ($encryptionState -ne "1")
    {

    if ($clientStatusDetails -ne $null -and $clientStatusDetails -ne "" -or $clientStatusDetails -eq 0)
        {
        Write-Output "$encryptionStateStatus at $($clientStatusDetails)%"
        Show-TSActionProgress -Message "$encryptionStateStatus $($clientStatusDetails)%" -Step $clientStatusDetails -MaxStep 100 -ErrorAction SilentlyContinue
        do
            {
            start-sleep -Seconds 60
            Get-CheckPointStatus
            Write-Output "$encryptionStateStatus at $($clientStatusDetails)%"
            Show-TSActionProgress -Message "$encryptionStateStatus $($clientStatusDetails)%" -Step $clientStatusDetails -MaxStep 100 -ErrorAction SilentlyContinue
            }
        until
            (
            $encryptionStateStatus -eq "Encrypted" -or $encryptionStateStatus -eq "Not Encrypted"
            )
        }
    }
else
    {
    Write-Output "System is fully encrypted"
    }
Write-Output " "
Write-Output "------------------------------------------"
[Void]([wmiclass]'ROOT\ccm:SMS_Client').TriggerSchedule('{00000000-0000-0000-0000-000000000001}')